/* u炭v̌ł̃f[^ovO
**
** libpng ꍇF
** % g++ -DPNG -o raku_ext raku_ext.cc -lpng
** % ./raku_ext data_script.pac
** % ./raku_ext data_cg.pac
**
** ligpng Ȃꍇi摜t@Cx^Ȍ`ŏo͂)
** % g++ -o raku_ext raku_ext.cc
** % ./raku_ext data_script.pac
** % ./raku_ext data_cg.pac
**
** 摜 bytes per line ̌vZɂ킩ȂƂ낪̂
** 摜{^Ȃǂ͕ςɂȂ܂B
*/

/*
 * Copyright 2003  jagarl / Kazunori Ueno <jagarl@creator.club.ne.jp>
 * All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted.
 *
 * ̃vO̍҂ jagarl łB
 *
 * ̃vOAyуRpCɂĐoCi
 * vOύXAȂɂ炸Ĕzz\łB
 * ̍ہAL Copyright \ێȂǂ͉̏ۂ
 * BΉʓ|Ȃ̂ŃoO񍐂A[ŘA
 * Ȃǂ̕Kv܂B\[Ẍꕔ𗬗p邱Ƃ܂߁A
 * RɂgB
 *
 * THIS SOFTWARE IS PROVIDED BY KAZUNORI 'jagarl' UENO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL KAZUNORI UENO BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 * 
 */

#include<stdio.h>
#include<stdlib.h>
#include<string>
#include<vector>

#define PNG

using namespace std;

inline int read_big_int(const char* buf) {
	const unsigned char *p = (const unsigned char *) buf;
	return (p[3]) | (p[2] << 8) | (p[1] << 16) | (p[0]<<24);
}

inline int read_big_short(const char* buf) {
	const unsigned char *p = (const unsigned char *) buf;
	return (p[0] << 8) | p[1];
}

namespace FILESYS {
struct ATOM {
	string name;
	int offset;
	ATOM(const char* n, int off) : name(n), offset(off) {}
};

struct DATA {
	
};

struct FILES {
	vector<ATOM> files;
	string filename;
	FILES(const char* path);
	int Size(void) { return files.size(); }
	const string Name(int num) {
		if (num < 0 || num >= files.size()) return "";
		return files[num].name;
	}
	char* Read(int count, int& length, char** seeds_ret = 0, int* seed_len_ret = 0);
	static void decode_lz(char*& data, int& length);
	static void decode_run(char*& data, int& length);
	static void decode_diff(char* data, int length);
	static void decode_mono(char* data, int length);
};

char* FILES::Read(int count, int& len_ret, char** seeds_ret, int* seed_len_ret) {
	char header[16];
	len_ret = 0;
	if (files.empty()) return 0;
	if (count < 0 || count >= files.size()) return 0;
	int offset = files[count].offset;
	FILE* stream = fopen(filename.c_str(), "rb");
	if (stream == 0) return 0;
	fseek(stream, offset, 0);
	if (ftell(stream) != offset) return 0;

	/* data stream :
	** +00 'HA0'
	** +03 seed count (char)
	** +04 compressed data size (int)
	** +08 cmopress method-1
	** +09 cmopress method-2
	** +0A cmopress method-3
	** +0B cmopress method-4
	** +0C-0F : unknown
	** +10 - +10+seed count : unknown
	** rest : compressed data
	*/
	fread(header, 0x10, 1, stream);
	if (strncmp(header, "HA0", 3) != 0) return 0;
	int seed_len =(unsigned char)header[3];
	if (seed_len_ret) *seed_len_ret = seed_len;
	if (seeds_ret) {
		*seeds_ret = new char[seed_len];
		fread(*seeds_ret, seed_len, 1, stream);
	} else {
		fseek(stream, seed_len, 1); // unknown data
	}
	int datasize = read_big_int(header+4);
	char* data = new char[datasize];
	fread(data, datasize, 1, stream);
	fclose(stream);

	int i; for (i=3; i>=0; i--) {
		char type = header[8+i];
		switch(type) {
		case 1: decode_run(data, datasize); break;
		case 2: decode_mono(data, datasize); break;
		case 3: decode_diff(data, datasize); break;
		case 4: decode_lz(data, datasize); break;
		}
		if (data == 0) break;
	}
	len_ret = datasize;
	return data;
}

void FILES::decode_mono(char* data, int length) {
	char* work = new char[length/3+1];
	memcpy(work, data, length/3+1);
	int i;
	int len2 = length / 3;
	for (i=0; i<len2; i++) {
		char c = *work++;
		data[0] = c;
		data[1] = c;
		data[2] = c;
		data += 3;
	}
	length %= 3;
	for (i=0; i<length; i++)
		*data++ = *work;
	delete[] work;
	return;
}

void FILES::decode_diff(char* data, int length) {
	int i; unsigned char* c = (unsigned char*) data;
	for (i=1; i<length; i++) {
		 *c += c[-1]; c++;
	}
	return;
}

void FILES::decode_run(char*& data, int& len_orig) {
	char* src = data;
	int new_len = read_big_int(src);
	int proc_len = read_big_int(src+4);
	int flag_len = read_big_int(src+8);

	char* flags = src + 0x0c; char* flagend = flags+flag_len;
	char* s = src + 0x0c + flag_len; char* send = src + len_orig;

	char* new_data = new char[new_len];
	char* d = new_data; char* dend = new_data + new_len;
	*flags &= 0xfe; // first data is original
	while(s < send && d < dend && flags < flagend) {
		char flag = *flags++;
		int i; for (i=0; i<8 && s<send && d<dend; i++) {
			if (flag & 1) { // copy
				*d = d[-1]; d++;
			} else { // original
				*d++ = *s++;
			}
			flag >>= 1;
		}
	}
	delete[] src;
	len_orig = new_len; data = new_data;
	return;
}

void FILES::decode_lz(char*& data, int& len_orig) {
	char* src = data;
	int new_len = read_big_int(src);
	int proc_len = read_big_int(src+4);
	int flag_len = read_big_int(src+8);

	char* flags = src + 0x0c; char* flagend = flags+flag_len;
	char* s = src + 0x0c + flag_len; char* send = src + len_orig;
	char* new_data = new char[new_len];
	char* d = new_data; char* dend = new_data + new_len;
	
	while(s < send && d < dend && flags < flagend) {
		char flag = *flags++;
		int i; for (i=0; i<8 && s<send && d<dend; i++) {
			if (flag & 1) { // copy
				int off = (unsigned char)*s++;
				int sz = (unsigned char)*s++;
				int j; for (j=0; (j<sz)&&(d<dend); j++) {
					*d = d[-off]; d++;
				}
			} else { // original
				*d++ = *s++;
			}
			flag >>= 1;
		}
	}
	delete[] src;
	len_orig = new_len; data = new_data;
	return;
}

FILES::FILES(const char* path) {
	int i;
	char header[0x16];
	char* buffer=0, *buforig=0, *bufend;
	int count, length;

	filename = "";
	FILE* stream = fopen(path, "rb");
	if (stream == 0) return;
	fseek(stream, 0, 2); int fsize = ftell(stream); fseek(stream, 0, 0);

	fread(header, 0x16, 1, stream);
	if (strncmp(header, "DAI_SYSTEM_01000", 16) != 0) goto err;
	count = read_big_short(header+0x10);
	length = read_big_int(header+0x12);
	if (length < 0 || length > 0x1000000 || length > fsize) goto err; // cf. data_cg.pac : length = 0x330a

	buffer = buforig = new char[length];
	fread(buffer, length, 1, stream);
	for (i=0; i<length; i++) {
		buffer[i] -= 0x28+i; // decrypt
	}

	bufend = buffer + length;
	for (i=0; i<count; i++) {
		char* name = buffer;
		while(buffer < bufend && *buffer != 0x2c) buffer++;
		if (buffer >= bufend) break;
		*buffer++ = 0;
		int off = read_big_int(buffer);
		buffer += 5;
		files.push_back(ATOM(name, off));
	}

	delete[] buforig;
	filename = path;
err:
	fclose(stream);
	return;
}
};

#ifdef PNG
#include "png.h"
#pragma comment(lib, "libpng.lib")
#pragma comment(lib, "zlib.lib")
typedef enum {rgb, rgba} color_mode;
void create_png(FILE* stream, char* path, char* desc, int width, int height, char* data, color_mode cmode);

void create_png(FILE* stream, char* path, char* desc, int width, int height, char* data, color_mode cmode) {
	png_structp png_ptr;
	png_infop info_ptr;

	/* create struct */
	png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	if (png_ptr == NULL) return;

	/* initialize information */
	info_ptr = png_create_info_struct(png_ptr);
	if (info_ptr == NULL) {
		png_destroy_write_struct(&png_ptr, (png_infop*)NULL);
		return;
	}

	if (setjmp(png_jmpbuf(png_ptr))) {
		/* error occured !! */
		png_destroy_write_struct(&png_ptr,&info_ptr);
		fprintf(stderr, "Get error while processing PNG from file %s\n",path);
		return;
	}

	/* initialize I/O (for stream) */
	png_init_io(png_ptr, stream);

	/* initialize headers */
	png_set_IHDR(png_ptr, info_ptr,
		width, height, 8 /* bit_dept */,
		cmode == rgb ? PNG_COLOR_TYPE_RGB : PNG_COLOR_TYPE_RGB_ALPHA,
		PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);
	/* create text information */
	png_text info_text[3];
	info_text[0].key = "Title";
	info_text[0].text= path;
	info_text[0].compression = PNG_TEXT_COMPRESSION_NONE;
	info_text[1].key = "Author";
	info_text[1].text= "";
	info_text[1].compression = PNG_TEXT_COMPRESSION_NONE;
	info_text[2].key = "Description";
	info_text[2].text= desc;
	info_text[2].compression = PNG_TEXT_COMPRESSION_NONE;
	png_set_text(png_ptr, info_ptr, info_text, 3);

	/* write information */
	png_write_info(png_ptr, info_ptr);

	/* write body */
	if (cmode == rgb) {
		/* rgb image ; input is 32bpp -> output is 24 bpp.*/
		char* row = new char[width*3];
		int i; for (i=0; i<height; i++) {
			int l = (width*3+3)&(~3);
			char* row_ptr = row;
			char* r = data + (height-i-1)*l + 2;
			char* g = data + (height-i-1)*l + 1;
			char* b = data + (height-i-1)*l;
			int j; for (j=0; j<width; j++) {
				row_ptr[0] = *r;
				row_ptr[1] = *g;
				row_ptr[2] = *b;
				r += 3;
				g += 3;
				b += 3;
				row_ptr += 3;
			}
			png_write_rows(png_ptr, (png_byte**)&row, 1);
		}
		delete[] row;
	} else /* if (cmode == rgba) */ {
		/* rgba image ; input/output is 32bpp.*/
		char* row = new char[width*4];
		int i; for (i=0; i<height; i++) {
			int l = (width*3+3)&(~3);
			char* row_ptr = row;
			char* r = data + (height-i-1)*l + 2;
			char* g = data + (height-i-1)*l + 1;
			char* b = data + (height-i-1)*l + 0;
			char* a = data + height*l + (height-i-1)*width;
			int j; for (j=0; j<width; j++) {
				row_ptr[0] = *r;
				row_ptr[1] = *g;
				row_ptr[2] = *b;
				row_ptr[3] = *a;
				r += 3;
				g += 3;
				b += 3;
				a++;
				row_ptr += 4;
			}
			png_write_rows(png_ptr, (png_byte**)&row, 1);
		}
		delete[] row;
	}
	png_write_end(png_ptr, info_ptr);
	png_destroy_write_struct(&png_ptr, &info_ptr);
	return;
}
#endif

int main(int argc, char** argv){
	if (argc != 2) return -1;
	FILESYS::FILES pac(argv[1]);
	int len = pac.Size();
	int i;
	char* seeds; int seed_len;
	for (i=0; i<len; i++) {
		int l;
		char* d = pac.Read(i, l, &seeds, &seed_len);
		if (d != 0) {
			const string name = pac.Name(i);
			/* ViȈꍇAx^ŏo */
			if (seed_len != 5) { // not graphics
printf("%d: %s len %d\n",i,name.c_str(),l);
				FILE* f = fopen(name.c_str(), "wb");
				if (f) {
					fwrite(d, l, 1, f);
					fclose(f);
				}
			}
#ifdef PNG
			else {
			/* 摜̏ꍇ png ɂ
			** width/height ̓A[JCuWJɓɊ܂܂Ă
			** `F
			** mask ȂF 
			**   P r,g,b  width*height 
			** mask F
			**   ŏ r,g,b ݂̂̕ԃf[^B
			**   PCA width*3+1 ̃f[^ x height
			**  ̂Ƃ width * height ̃f[^ alpha channel 
			**
			** ̊G{^֌ẂAPC width*3 炵iȂ̂ŁÃ݂ASYł͂)
			**/
				int width = read_big_short(seeds);
				int height = read_big_short(seeds+2);
				int type = seeds[4];
printf("%d: %s w %d h %d len %d\n",i,name.c_str(),width,height,l);
				char* path = new char[strlen(name.c_str())+10];
				strcpy(path, name.c_str()); strcat(path, ".png");
				FILE* f = fopen(path, "wb");
				if (f) {
					if (type) create_png(f, path, "", width, height, d, rgba);
					else create_png(f, path, "", width, height, d, rgb);
					fclose(f);
				}
				delete[] path;
			}
#endif
			delete[] d;
			delete[] seeds;
		}
	}
	return 0;
}
