/*
 *
 *  Copyright (C) 2001-   Kazunori Ueno(JAGARL) <jagarl@creator.club.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

// wpd ` koe.pac `ւ̕ϊ

#include<map>
#include<string>
#include"file.h"
#include"waffle_koe.h"
using namespace std;

short* decode_koe_wpd(char* src, int srclen, int* dest_len);

/* KoeArc:  */
class KoeArc {
public:
	KoeArc(const char* path);
	~KoeArc(void);
	void Add(short* wav, int wavlen);
};
static int koe_chara_table[1000];
static map<string, int> koe_map;
static map<int,string> koe_map_rev;

void koe_conv(const char* base_dir) { /* base_dir == "./koe/" */
	/* t@C͓ */
	PacArc arc1("VOICE1ST.PAC");
	PacArc arc2("VOICE2ND.PAC");
	WaffleKoePac WflKoe;
	int i;
	int num = 0;

	// ݂̑e[u𐔂
	for (i=0; i<1000; i++) {
		if (koe_chara_table[i]>0) num++;
	}

	if ( !WflKoe.InitPac(".\\koe.pac", num, 32) ) return;

	for (i=0; i<1000; i++) {
		/* t@CƂ̏ */
		if (koe_chara_table[i] == 0) continue;

		if ( !WflKoe.InitFile(koe_chara_table[i], i) ) continue;

		int j; for (j=0; j<koe_chara_table[i]; j++) {
			/* Pt@C̏ */
			int fileno = i*100000 + j+1;
			if (koe_map_rev.find(fileno) == koe_map_rev.end()) continue;
			/* archive ǂݍ */
			char name[1024];
			string koename = koe_map_rev[fileno];
			sprintf(name, "%s.wpd", koename.c_str());
			printf("\rFID=%03d VID=%04d  %s        ", i, j, name);
			char* src = 0; int srclen;
			src = arc1.Find(name, srclen);
			if (src == 0)
				src = arc2.Find(name, srclen);
			if (src == 0)
				continue;
			/* mono, short* ̃f[^ɕϊ */
			int wavlen;
			short* wavdata = 0;
			wavdata = decode_koe_wpd(src, srclen, &wavlen);
			delete[] src;
			if (wavdata == 0) continue;
			/* archiveɒǉ */
			WflKoe.AddFile(j+1, wavdata, wavlen*2);
			delete[] wavdata;
		}

		WflKoe.EndFile();
	}

	printf("\n");
	WflKoe.EndPac();

	return;
}
		
/* wpd <-> koe ̔ԍΉ\ */
int wpdtonumber(const char* wpdname, const char* scnname) {
	char buf1[1024], buf2[1024];
	strncpy(buf1, wpdname, 1000); buf1[1000]=0;
	strncpy(buf2, scnname, 1000); buf2[1000]=0;
	/* ɂ */
	int i;
	for (i=0; buf1[i] != 0; i++) buf1[i]=tolower(buf1[i]);
	for (i=0; buf2[i] != 0; i++) buf2[i]=tolower(buf2[i]);
	/* Ɏgt@CH */
	string wpdstr = buf1;
	if (koe_map.find(wpdstr) != koe_map.end()) {
		return koe_map[wpdstr];
	}
	/* ߂ */
	int month = 0;
	if (strncmp(buf2, "cmn0407_",8) == 0) month = 13;
	else if (strncmp(buf2, "cmn", 3) == 0) {
		buf2[5] = 0;
		month = atoi(buf2+3);
	} else if (strncmp(buf2, "prologue",8) == 0) month = 4;
	else if (strncmp(buf2,"outblock",8) == 0) month = 12;
	else if (strncmp(buf2,"falseend",8) == 0) month = 12;
	else if (strncmp(buf2,"trueend",7) == 0) month = 13;
	else if (strncmp(buf2,"seenmode",8) == 0) month = 1;
	/* LN^߂ */
	int chara = 6;
	if (strncmp(buf1, "vono", 4) == 0) chara = 1; /* ] */
	else if (strncmp(buf1, "vokm",4) == 0) chara = 2; /*  */
	else if (strncmp(buf1, "vots",4) == 0) chara = 3; /* ΂ */
	else if (strncmp(buf1, "vokd",4) == 0) chara = 4; /*  */
	else if (strncmp(buf1, "voao",4) == 0) chara = 5; /* t */
	
	int file_number = month*10 + chara;
	int new_number = ++koe_chara_table[file_number];
	/* map ɑ */
	koe_map[wpdstr] = file_number*100000 + new_number;
	koe_map_rev[file_number*100000 + new_number] = wpdstr;
	return file_number*100000 + new_number;
}


/* f[^̃rbgXg[ǂ݂߂̃NX */
struct GB {
        unsigned int v;
        int b;
        char* d;

        char* d4; int d4_flag;
        char* d8;
        char* d16;
public:
        GB(char* dd) {
                d = dd + read_little_endian_int(dd);
                d4 = dd + read_little_endian_int(dd+4);
                d8 = dd + read_little_endian_int(dd+8);
                d16 = dd + read_little_endian_int(dd+12);
                v=read_little_endian_int(d); b=0; d=d+4;
                d4_flag = 0;
        }
        int get3(void){
                int ret = (v>>b)&7;
                b += 3;
                if(b>8) {
                        b-=8;
                        v>>=8;
                        v|=int(*(unsigned char*)d)<<24;
                        d++;
                }
                return ret;
        }
        int get4(void) {
                if (d4_flag) {
                        d4_flag = 0; d4++;
                        return *(unsigned char*)(d4-1)>>4;
                } else {
                        d4_flag = 1;
                        return *d4 & 0x0f;
                }
        }
        int get8(void) {
                return *(unsigned char*)d8++;
        }
        int get12(void){
                return (get4()<<8) | get8();
        }
        int get16(void) {
                d16 += 2;
                return read_little_endian_short(d16-2);
        }
};

short* decode_koe_wpd(char* src, int srclen, int* dest_len) {
        char magic[4] = {0x20, 0x44, 0x50, 0x57};
	if (strncmp(src, magic, 4) != 0) return 0;
	if (read_little_endian_int(src+4) != 1) return 0;
	if (read_little_endian_int(src+8) != 2) return 0;

        int outsize = read_little_endian_int(src+0x18);
	outsize /= 2;
        short* outbuf = new short[outsize+1024];
        short* outptr = outbuf;
        short* outend = outbuf + outsize;

        int i; int data = 0;
        GB bits(src+0x44);
        while(outptr < outend) {
                int flag = bits.get3();
                switch(flag) {
                case 0: data=bits.get16(); break;
                        break;
                case 1: data += bits.get4(); break;
                case 2: data -= bits.get4(); break;
                case 3: data += bits.get8(); break;
                case 4: data -= bits.get8(); break;
                case 5: data += bits.get12(); break;
                case 6: data -= bits.get12(); break;
                case 7: {
                        int count = bits.get8();
                        int i;
                        if ( count<=0 ) continue;
                        for (i=0; i<count; i++) {
				*outptr++ = data*8;
//				*outptr++ = data*8;
                        }
                        outptr--;
                        break; }
                }
		*outptr++ = data*8;
//		*outptr++ = data*8;
        }
        if (outptr - outend != 0) {
            fprintf(stderr, "wpd: overrun = %d\n", outptr - outend);
        }
	if (dest_len) *dest_len = outsize;
	return outbuf;
}

KoeArc::KoeArc(const char* path) {
	fprintf(stderr,"Unsupported Method KoeArc::KoeArc\n");
	abort();
}
KoeArc::~KoeArc(void) {
	fprintf(stderr,"Unsupported Method KoeArc::~KoeArc\n");
	abort();
}
void KoeArc::Add(short* wav, int wavlen) {
	fprintf(stderr,"Unsupported Method KoeArc::Add\n");
	abort();
}
