#ifndef __WAFFLE_KOE_H
#define __WAFFLE_KOE_H


#pragma pack(push, 1)
typedef struct {
	unsigned long tid, pos;
} ETRTABLE;

typedef struct {
	unsigned short id;
	unsigned short symbol;
	unsigned long  pos;
} IDTABLE;

typedef struct {
	char id[16];
	int num;
	int dummy[3];
} PACHEAD;
#pragma pack(pop)


class WaffleKoePac
{
public:
	WaffleKoePac();
	~WaffleKoePac();
	bool InitPac(const char* outpath, int num, int mp3rate);
	void EndPac();
	bool InitFile(int num, int id);
	void EndFile();
	bool AddFile(int id, const short* buf, int len);
private:
	void* pFile;
	ETRTABLE* Entry;
	IDTABLE* IDTable;
	PACHEAD Header;
	int pos;
	int filepos;
	int curentry;
	int curfile;
	int maxfile;
	int bitrate;
};

#endif //__WAFFLE_KOE_H
