// -------------------------------------------------------------------
// Converter routines
// -------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mp3enc.h"
#include "waffle_koe.h"

WaffleKoePac::WaffleKoePac()
{
	pFile = NULL;
	Entry = NULL;
	IDTable = NULL;
	memset(&Header, 0, sizeof(PACHEAD));
	strcpy(Header.id, "KOEMP3");
	pos = 0;
	curentry = 0;
	curfile = 0;
	maxfile = 0;
	bitrate = 32;
}

WaffleKoePac::~WaffleKoePac()
{
}

bool WaffleKoePac::InitPac(const char* outfile, int num, int mp3rate)
{
	if ( num<=0 ) return false;
	if ( !Load_GOGO() ) {
		printf("WflKoe() : Cannot open GOGO.DLL\n");
		return false;
	}
	pFile = (void*)fopen(outfile, "wb");
	if ( !pFile ) return 0;
	Entry = (ETRTABLE*)malloc(sizeof(ETRTABLE)*num);
	if ( !Entry ) {
		fclose((FILE*)pFile);
		return false;
	}
	Header.num = num;
	memset(Entry, 0, sizeof(ETRTABLE)*num);
	fwrite(&Header, sizeof(PACHEAD), 1, (FILE*)pFile);
	fwrite(Entry, sizeof(ETRTABLE), num, (FILE*)pFile);
	pos = sizeof(PACHEAD) + (sizeof(ETRTABLE)*num);
	bitrate = mp3rate;
	return true;
}


void WaffleKoePac::EndPac()
{
	if ( pFile ) {
		fseek((FILE*)pFile, 0, 0);
		fwrite(&Header, sizeof(PACHEAD), 1, (FILE*)pFile);
		if ( Entry ) fwrite(Entry, sizeof(ETRTABLE), Header.num, (FILE*)pFile);
		fclose((FILE*)pFile);
		pFile = NULL;
	}
	Unload_GOGO();
}


bool WaffleKoePac::InitFile(int num, int id)
{
	if ( !pFile ) return false;
	if ( curentry>=Header.num ) return false;
	if ( IDTable ) return false;
	if ( num<=0 ) return false;
	IDTable = (IDTABLE*)malloc(sizeof(IDTABLE)*num);
	if ( !IDTable ) return false;
	memset(IDTable, 0, sizeof(IDTABLE)*num);
	fseek((FILE*)pFile, pos, 0);
	fwrite(IDTable, sizeof(IDTABLE), num, (FILE*)pFile);
	filepos = pos;
	pos += sizeof(IDTABLE)*num;
	maxfile = num;
	curfile = 0;
	Entry[curentry].pos = filepos;
	Entry[curentry].tid = (id*100000)+num;
	return true;
}

void WaffleKoePac::EndFile()
{
	if ( !IDTable ) return;
	if ( !pFile ) return;
	if ( pos&7 ) {
		char pad[8];
		memset(pad, 0, 8);
		fwrite(pad, 8-(pos&7), 1, (FILE*)pFile);
	}
	fseek((FILE*)pFile, filepos , 0);
	fwrite(IDTable, sizeof(IDTABLE), maxfile, (FILE*)pFile);
	fseek((FILE*)pFile, pos , 0);
	free(IDTable);
	IDTable = NULL;
	maxfile = 0;
	filepos = 0;
	curentry++;
}


bool WaffleKoePac::AddFile(int id, const short* buf, int len)
{
	int size;
	if ( curfile>=maxfile ) return false;
	size = EncodeGOGO((unsigned char*)buf, len, 0, 22050, 16,
		0, 22050, bitrate, pFile);
	IDTable[curfile].id  = id;
	IDTable[curfile].pos = size;
	curfile++;
	pos += size;
	return true;
}
