#include <stdio.h>
#include <windows.h>
#include "mp3enc.h"

#define ME_NOERR       0
#define ME_EMPTYSTREAM 1
#define MGV_BUFLENGTH 260

typedef int (__cdecl *Func_initializeWork)(void);
typedef int (__cdecl *Func_setConfigure)(unsigned long mode, unsigned long dwPara1, unsigned long dwPara2);
typedef int (__cdecl *Func_getConfigure)(unsigned long mode, void *para1);
typedef int (__cdecl *Func_detectConfigure)(void);
typedef int (__cdecl *Func_processFrame)(void);
typedef int (__cdecl *Func_closeCoder)(void);
typedef int (__cdecl *Func_endCoder)(void);
typedef int (__cdecl *Func_getUnitStates)(unsigned long *unit);
typedef int (__cdecl *Func_processTrack)(void);
typedef int (__cdecl *Func_getVersion)(unsigned long *vercode,  char *verstring);

typedef struct {
	int (*pUserFunc)(void *buf, unsigned long nLength);
	unsigned int nSize;
	int nBit;
	int nFreq;
	int nChn;
} MCP_INPDEV_USERFUNC;

typedef struct {
	HMODULE              module;
	unsigned long        version;
	char                 verstring[MGV_BUFLENGTH];

	Func_initializeWork  initializeWork;
	Func_setConfigure    setConfigure;
	Func_getConfigure    getConfigure;
	Func_detectConfigure detectConfigure;
	Func_processFrame    processFrame;
	Func_closeCoder      closeCoder;
	Func_endCoder        endCoder;
	Func_getUnitStates   getUnitStates;
	Func_processTrack    processTrack;
	Func_getVersion      getVersion;
} STRUCT_GOGO_DLL;

typedef struct {
	char *name;
	int offset;
} _DLLFUNCS;

#define	_STOFF(x)	(int)&(((STRUCT_GOGO_DLL*)NULL)->x)

static const _DLLFUNCS GOGO_Procs[] = {
	{ "MPGE_initializeWork",  _STOFF(initializeWork)  },
	{ "MPGE_setConfigure",    _STOFF(setConfigure)    },
	{ "MPGE_getConfigure",    _STOFF(getConfigure)    },
	{ "MPGE_detectConfigure", _STOFF(detectConfigure) },
	{ "MPGE_processFrame",    _STOFF(processFrame)    },
	{ "MPGE_closeCoder",      _STOFF(closeCoder)      },
	{ "MPGE_endCoder",        _STOFF(endCoder)        },
	{ "MPGE_getUnitStates",   _STOFF(getUnitStates)   },
	{ "MPGE_processTrack",    _STOFF(processTrack)    },
	{ "MPGE_getVersion",      _STOFF(getVersion)      }
};

static STRUCT_GOGO_DLL gogo = { NULL };


static const char GOGODLL_RegKey[] = "Software\\MarineCat\\GOGO_DLL";
static const char GOGOWIN_RegKey[] = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\WinGOGO";

static HMODULE SearchGOGO(void)
{
	HMODULE hmod = 0;
	HKEY hKey;
	char buf[MAX_PATH];

	hmod = LoadLibrary("GOGO.DLL");		// ܂pXʂƂT

	if ( !hmod ) {						// _ȂAŌɎgꂽGOGO.DLLT
		if ( RegOpenKeyEx(HKEY_CURRENT_USER, GOGODLL_RegKey, 0, KEY_READ, &hKey)==ERROR_SUCCESS ) {		// KeỹI[v
			int type = 0, size = MAX_PATH;
			if ( RegQueryValueEx(hKey, "INSTPATH", 0, &type, (unsigned char*)buf, &size)==ERROR_SUCCESS ) {		// 擾
				hmod = LoadLibrary(buf);
			}
			RegCloseKey(hKey);
		}
	}
	if ( !hmod ) {						// ł_ȂAWinGOGÕCXg[T
		if ( RegOpenKeyEx(HKEY_LOCAL_MACHINE, GOGOWIN_RegKey, 0, KEY_READ, &hKey)==ERROR_SUCCESS ) {		// KeỹI[v
			int type = 0, size = MAX_PATH;
			if ( RegQueryValueEx(hKey, "UninstallString", 0, &type, (unsigned char*)buf, &size)==ERROR_SUCCESS ) {		// 擾
				strcpy(strrchr(buf, '\\')+1, "GOGO.DLL");
				// 擪 " ̂Œ
				hmod = LoadLibrary(buf+1);
			}
			RegCloseKey(hKey);
		}
	}
	return hmod;
}


const char* GetGOGOVersion(void)
{
	return gogo.verstring;
}


void Unload_GOGO(void)
{
	if ( gogo.module ) FreeLibrary(gogo.module);
	ZeroMemory(&gogo, sizeof(STRUCT_GOGO_DLL));
}


int Load_GOGO(void)
{
	int i;
	int ret = TRUE;
	const _DLLFUNCS *dp;

	Unload_GOGO();
	gogo.module = SearchGOGO();
	if ( !gogo.module ) return FALSE;
	for (i=0, dp=GOGO_Procs; i<(sizeof(GOGO_Procs)/sizeof(_DLLFUNCS)); i++, dp++) {
		FARPROC proc = GetProcAddress(gogo.module, dp->name);
		if ( !proc ) {
			ret = FALSE;
			break;
		}
		*(DWORD*)(((BYTE*)&gogo)+(dp->offset)) = (DWORD)proc;
	}

	if ( !ret ) {
		Unload_GOGO();
	} else {
		if ( gogo.getVersion(&gogo.version, gogo.verstring)!=ME_NOERR ) ret = FALSE;
	}
	return (gogo.version);
}


static struct {
	unsigned char* in;
	int in_count;
	int in_buffered;
	int in_remain;
	int out_buffered;
	FILE *fp;
} iocbWork;


int __cdecl outputCallback(void *buf, unsigned long nLength)
{
	if (buf) {
		fwrite(buf, 1, nLength, iocbWork.fp);
		iocbWork.out_buffered += nLength;
	}
	return ME_NOERR;
}


int __cdecl inputCallbackMP3(void *buf, unsigned long nLength)
{
	int size = nLength;
	if ( !iocbWork.in_remain ) return ME_EMPTYSTREAM;
	if ( (int)nLength>iocbWork.in_remain ) size = iocbWork.in_remain;
	memcpy(buf, iocbWork.in, size);
	iocbWork.in += size;
	iocbWork.in_remain -= size;
	if ( size<(int)nLength ) memset((char*)buf+size, 0, (int)nLength-size);
	return ME_NOERR;
}


int EncodeGOGO(unsigned char* buf, int size, int st, int freq, int bits, int outst, int outfreq, int outrate, void* outfp)
{
	int result = 0;
	MCP_INPDEV_USERFUNC ufnc;

	memset(&iocbWork, 0, sizeof(iocbWork));
	iocbWork.fp = (FILE*)outfp;
	do {
		if ( !buf ) break;
		if ( gogo.initializeWork()!=ME_NOERR ) break;
		ufnc.nChn  = st+1; // Channel
		if ( (ufnc.nChn!=1)&&(ufnc.nChn!=2) ) break;
		ufnc.nFreq = freq;
		ufnc.nBit  = bits;
		ufnc.pUserFunc = inputCallbackMP3;
		ufnc.nSize = 0;
		iocbWork.in_remain = size;
		iocbWork.in_buffered = 0;
		iocbWork.in_count = 0;
		iocbWork.in = buf;
		iocbWork.out_buffered = 0;
		if ( gogo.setConfigure(1/*MC_INPUTFILE*/,  2/*MC_INPDEV_USERFUNC*/, (unsigned long)&ufnc)!=ME_NOERR ) break;
		if ( gogo.setConfigure(2/*MC_OUTPUTFILE*/, 2/*MC_OUTDEV_USERFUNC*/, (unsigned long)outputCallback)!=ME_NOERR ) break;
		if ( gogo.setConfigure(3/*MC_ENCODEMODE*/, outst/*MC_MODE_STEREO*/, 0)!=ME_NOERR ) break;
		if ( gogo.setConfigure(4/*MC_BITRATE*/, outrate, 0)!=ME_NOERR ) break;  //rbg[gw
		if ( gogo.setConfigure(6/*MC_OUTFREQ*/, outfreq, 0)!=ME_NOERR ) break;
		gogo.setConfigure(10/*MC_USEMMX*/,    0, 0);
		gogo.setConfigure(11/*MC_USE3DNOW*/,  0, 0);
		gogo.setConfigure(12/*MC_USEKNI*/,    0, 0);
		gogo.setConfigure(13/*MC_USEE3DNOW*/, 0, 0);
		gogo.setConfigure(38/*MC_USECMOV*/,   0, 0);
		gogo.setConfigure(39/*MC_USEEMMX*/,   0, 0);
		gogo.setConfigure(40/*MC_USESSE2*/,   0, 0);
		if ( gogo.detectConfigure()!=ME_NOERR ) break;
		while ( gogo.processFrame()==ME_NOERR );
		result = iocbWork.out_buffered;
	} while ( 0 );
	gogo.closeCoder();
	gogo.endCoder();

	// vvg[hŎgĂƃXbh݂}Ŷcc
	// EFCƓƉ₷肷邯ǁAR[킩cc
	Sleep(10);

	return result;
}
